<?php

// Include the database conn
include_once 'db.php';

// Start session
session_start();

// Set the content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if the 'id' parameter is set
    if (isset($_POST['id'])) {
        // Sanitize the 'id' parameter
        $id = mysqli_real_escape_string($conn, $_POST['id']);

        // Base SQL query
        $sql = "SELECT count(*) as total FROM orders ord INNER JOIN customer c ON c.id = ord.user_id";
        switch ($id) {
            case '1':
                $sql .= " WHERE ord.Action_status = '1' AND ord.Delete_status = 0";
                break;
            case '2':
                $sql .= " WHERE ord.Action_status = '2' AND ord.Delete_status = 0";
                break;
            case '3':
                $sql .= " WHERE ord.Action_status = '3' AND ord.Delete_status = 0";
                break;
            case '4':
                $sql .= " WHERE ord.Action_status = '4' AND ord.Delete_status = 0";
                break;
                case '6':
                    $sql .= " WHERE ord.Action_status = '6' AND ord.Delete_status = 0";
                    break;
            default:
               
                break;
        }
        // Execute the query
        $result = mysqli_query($conn, $sql);

        // Check if the query execution was successful
        if ($result) {
            $row = mysqli_fetch_assoc($result);
            $total = $row['total'];

            // Return success response as JSON
            echo json_encode([
                $total
                
            ]);
        } else {
            // Return error response for query failure
            echo json_encode([
                'status' => 'error',
                'message' => 'Database query failed.'
            ]);
        }
    } else {
        // Return error response for missing 'id' parameter
        echo json_encode([
            'status' => 'error',
            'message' => 'Missing required parameter: id.'
        ]);
    }
} else {
    // Return error response for invalid request method
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method. Use POST.'
    ]);
}

?>
